<?php
/**
 * QUICK START GUIDE
 * Open this file in your browser to set up everything automatically
 */

if (!isset($_GET['step'])) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Cleaning Service - Quick Setup</title>
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            body {
                font-family: 'Poppins', sans-serif;
                background: linear-gradient(135deg, #109c3d 0%, #0f8c3d 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                border-radius: 20px;
                padding: 50px;
                max-width: 600px;
                width: 100%;
                box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            }
            h1 {
                color: #109c3d;
                margin-bottom: 10px;
                font-size: 32px;
            }
            .subtitle {
                color: #666;
                margin-bottom: 30px;
                font-size: 14px;
            }
            .steps {
                margin-bottom: 30px;
            }
            .step {
                display: flex;
                align-items: flex-start;
                margin-bottom: 20px;
                padding: 15px;
                background: #f8fbff;
                border-left: 4px solid #109c3d;
                border-radius: 8px;
            }
            .step-number {
                background: #109c3d;
                color: white;
                width: 35px;
                height: 35px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-weight: bold;
                margin-right: 15px;
                flex-shrink: 0;
            }
            .step-content h3 {
                color: #0f172a;
                margin-bottom: 5px;
            }
            .step-content p {
                color: #666;
                font-size: 13px;
                line-height: 1.6;
            }
            .buttons {
                display: flex;
                gap: 15px;
                margin-top: 30px;
            }
            .btn {
                flex: 1;
                padding: 14px 20px;
                border: none;
                border-radius: 8px;
                font-size: 15px;
                font-weight: 600;
                cursor: pointer;
                transition: all 0.3s ease;
                text-decoration: none;
                display: inline-block;
                text-align: center;
            }
            .btn-primary {
                background: linear-gradient(135deg, #109c3d, #0f8c3d);
                color: white;
            }
            .btn-primary:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 20px rgba(16, 156, 61, 0.3);
            }
            .btn-secondary {
                background: #f1f5f4;
                color: #109c3d;
                border: 2px solid #109c3d;
            }
            .btn-secondary:hover {
                background: #e8eeec;
            }
            .info-box {
                background: #e8f5e9;
                border-left: 4px solid #4caf50;
                padding: 15px;
                border-radius: 8px;
                margin-bottom: 20px;
            }
            .info-box p {
                color: #2e7d32;
                margin: 0;
            }
            .info-box strong {
                color: #1b5e20;
            }
            .error-box {
                background: #ffebee;
                border-left: 4px solid #f44336;
                padding: 15px;
                border-radius: 8px;
                margin-bottom: 20px;
            }
            .error-box p {
                color: #c62828;
                margin: 0;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>🧹 Cleaning Service Setup</h1>
            <p class="subtitle">Complete setup in 3 simple steps</p>

            <div class="info-box">
                <p><strong>✓ All pages converted to PHP</strong><br>All 14 pages now have database connection and reusable header/footer components</p>
            </div>

            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Create Database</h3>
                        <p>Click the button below to automatically create the database and all tables</p>
                    </div>
                </div>

                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>Verify Setup</h3>
                        <p>The setup will create 8 tables with sample data automatically</p>
                    </div>
                </div>

                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>Visit Website</h3>
                        <p>Navigate to the home page and start using your new PHP website</p>
                    </div>
                </div>
            </div>

            <div class="buttons">
                <a href="?step=setup" class="btn btn-primary">Run Setup Now</a>
                <a href="index.php" class="btn btn-secondary">Go to Home</a>
            </div>

            <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; font-size: 12px; color: #999;">
                <p><strong>📋 Database Details:</strong></p>
                <p>Name: cleaning_service<br>
                Tables: 8<br>
                Sample Data: Included</p>
            </div>
        </div>
    </body>
    </html>
    <?php
} else if ($_GET['step'] === 'setup') {
    // Run setup_database.php inline
    include 'setup_database.php';
}
?>
